#include "General.h"
#include "SetSFPS.h"
#include "engine_tt.h"
#include "engine_io.h"
#include "gmgame.h"

void Console(const char *Format, ...)
{
	char buffer[256];
	va_list va;
	_crt_va_start(va, Format);
	vsnprintf(buffer, 256, Format, va);
	va_end(va);
	Console_Input(buffer);
}

SetSFPS::SetSFPS()
{
	SFPS = 60;
	RegisterEvent(EVENT_GLOBAL_INI,this);
	RegisterEvent(EVENT_MAP_INI,this);
	RegisterEvent(EVENT_LOAD_LEVEL_HOOK,this);
}

SetSFPS::~SetSFPS()
{
	UnregisterEvent(EVENT_GLOBAL_INI,this);
	UnregisterEvent(EVENT_MAP_INI,this);
	UnregisterEvent(EVENT_LOAD_LEVEL_HOOK,this);
}

void SetSFPS::OnLoadGlobalINISettings(INIClass *SSGMIni)
{
	SFPS = SSGMIni->Get_Int("SetSFPS", "SFPS", 60);
}

void SetSFPS::OnFreeData()
{
}

void SetSFPS::OnLoadMapINISettings(INIClass *SSGMIni)
{
	SFPS = SSGMIni->Get_Int("SetSFPS", "SFPS", 60);
}

void SetSFPS::OnFreeMapData()
{
}
void SetSFPS::OnLoadLevel()
{
	Console("sfps %d", SFPS);
}

SetSFPS setSFPS;

extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &setSFPS;
}
